﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo
{
    public unsafe  partial class MyOSDPropertyDlg : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        // CONVERT COLOR TO UINT
        //
        private uint ColorToUInt(Color color)
        {
            return (uint)((color.A << 24) | (color.R << 16) | (color.G << 8) | (color.B << 0));
        }

        // CONVERT UINT TO COLORs
        //
        private Color UIntToColor(uint color)
        {
            byte a = (byte)(color >> 24);
            byte r = (byte)(color >> 16);
            byte g = (byte)(color >> 8);
            byte b = (byte)(color >> 0);

            return Color.FromArgb(a, r, g, b);
        }        

        public MySetupControl m_pMainForm;

        public uint m_hCapDev = 0x00000000;                         // STREAM CAPTURE DEVICE

        public string m_pszString = "YUAN";

        public string m_pszFontFamilyName = "Arial";

        public Color m_clrForeground;

        public Color m_clrBackground;

        public uint m_nOsdNum1 = 0, m_nOsdNum2 = 1, m_nOsdNum3 = 2;

        public uint m_dwFontColor = 0;

        public uint m_nFontSize = 24;

        public uint m_nFontStyle = (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_REGULAR;
        
        public uint m_dwBackgroundColor = 0;

        public int m_xoffset1 = 0, m_xoffset2 = 0, m_xoffset3 = 0;

        public int m_yoffset1 = 0, m_yoffset2 = 0, m_yoffset3 = 0;

        public int m_width1 = 320, m_width2 = 320, m_width3 = 320;

        public int m_height1 = 240, m_height2 = 240, m_height3 = 240;

        public uint m_nTransparent1 = 255, m_nTransparent2 = 255, m_nTransparent3 = 255;

        public string m_strPicturePath = "";

        public Bitmap m_PicImage = null;

        public MyOSDPropertyDlg()
        {
            InitializeComponent();
        }

        private void MyOSDPropertyDlg_Load(object sender, EventArgs e)
        {
            m_clrBackground = labelOSDBackgroundColor.BackColor;            

            comboxOSDLayer1.SelectedIndex = 0;

            comboxOSDLayer2.SelectedIndex = 1;

            comboxOSDLayer3.SelectedIndex = 2;

            comboxFontSize1.SelectedIndex = 9;

            txtBoxTypeString.Text = m_pszString;            
        }

        private void MyOSDPropertyDlg_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (m_PicImage != null)
            {
                m_PicImage.Dispose();
            }
        }

        private void btnApplyOSDText_Click(object sender, EventArgs e)
        {
            m_nOsdNum1 = (uint)comboxOSDLayer1.SelectedIndex;

            m_xoffset1 = Convert.ToInt32(txtBox_Xoffset1.Text);

            m_yoffset1 = Convert.ToInt32(txtBox_Yoffset1.Text);

            m_width1 = Convert.ToInt32(txtBox_width1.Text);

            m_height1 = Convert.ToInt32(txtBox_height1.Text);

            m_dwFontColor = ColorToUInt(txtBoxTypeString.ForeColor);

            m_dwBackgroundColor = ColorToUInt(m_clrBackground);            

            m_pszFontFamilyName = txtBoxTypeString.Font.FontFamily.Name;            

            m_nFontStyle = (uint)txtBoxTypeString.Font.Style;

            Font txtFont = txtBoxTypeString.Font;

            bool bBold = txtFont.Bold;

            if (bBold)  { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_BOLD; }

            bool bItalic = txtFont.Italic;

            if (bItalic) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_ITALIC; }

            bool bStrikeout = txtFont.Strikeout;

            if (bStrikeout) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_STRIKEOUT; }

            bool bUnderline = txtFont.Underline;

            if (bUnderline) { m_nFontStyle |= (uint)EXPORTS.FontStyleEnum.QCAP_FONT_STYLE_UNDERLINE; }

            m_nFontSize = Convert.ToUInt32(comboxFontSize1.Text);

            m_nTransparent1 = Convert.ToUInt32(txtBox_Transparent1.Text);

            m_pszString = txtBoxTypeString.Text;

            if (m_hCapDev != 0)
            {
                String str_string = m_pszString;

                String str_font_family_name = m_pszFontFamilyName;

                EXPORTS.QCAP_SET_OSD_TEXT(m_hCapDev, m_nOsdNum1, m_xoffset1, m_yoffset1, m_width1, m_height1,

                ref str_string, ref str_font_family_name, m_nFontStyle, m_nFontSize, m_dwFontColor,

                m_dwBackgroundColor, m_nTransparent1);                
            }
        }

        private void btnBrowsePicPath_Click(object sender, EventArgs e)
        {
            Stream fileStream;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "D:\\";

            openFileDialog1.Filter = "Image Files (*.bmp;*.png;*.jpg)|*.bmp;*.png;*.jpg|All Files (*.*)|*.*||";        

            openFileDialog1.FilterIndex = 0;

            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if ((fileStream = openFileDialog1.OpenFile()) != null)
                {
                    txtBoxPicPath.Text = openFileDialog1.FileName;

                    m_strPicturePath = txtBoxPicPath.Text;

                    if (m_PicImage != null)
                    {
                        m_PicImage.Dispose();
                    }

                    picBox.SizeMode = PictureBoxSizeMode.StretchImage;

                    m_PicImage = new Bitmap(m_strPicturePath);

                    picBox.Image = (Image)m_PicImage;

                    string strRes = m_PicImage.Width.ToString() + " x " + m_PicImage.Height.ToString();

                    txtboxImageRes.Text = strRes;

                    fileStream.Close();
                }
            }
        }

        private void btnApplyOSDPic_Click(object sender, EventArgs e)
        {
            m_nOsdNum2 = (uint)comboxOSDLayer2.SelectedIndex;            

            m_xoffset2 = Convert.ToInt32(txtBox_Xoffset2.Text);

            m_yoffset2 = Convert.ToInt32(txtBox_Yoffset2.Text);

            m_width2 = Convert.ToInt32(txtBox_width2.Text);

            m_height2 = Convert.ToInt32(txtBox_height2.Text);

            m_nTransparent2 = Convert.ToUInt32(txtBox_Transparent2.Text);

            if (m_hCapDev != 0)
            {
                string str_picture_path = m_strPicturePath;

                EXPORTS.QCAP_SET_OSD_PICTURE(m_hCapDev, m_nOsdNum2, m_xoffset2, m_yoffset2, m_width2, m_height2, ref str_picture_path, m_nTransparent2);
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Hide();
        }        

        private void btnChangeFont_Click_1(object sender, EventArgs e)
        {
            fontDialog1.Color = txtBoxTypeString.ForeColor;

            if (fontDialog1.ShowDialog() != DialogResult.Cancel)
            {
                txtBoxTypeString.Font = new Font(fontDialog1.Font.FontFamily, 12, fontDialog1.Font.Style);                

                txtBoxTypeString.ForeColor = fontDialog1.Color;

                labelOSDFontColor.BackColor = txtBoxTypeString.ForeColor;
            }
        }

        private void labelOSDFontColor_Click(object sender, EventArgs e)
        {
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDFontColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDFontColor.BackColor = ColorDlg.Color;

                m_clrForeground = ColorDlg.Color;

                txtBoxTypeString.ForeColor = m_clrForeground;
            }
        }

        private void labelOSDBackgroundColor_Click_1(object sender, EventArgs e)
        {
            ColorDialog ColorDlg = new ColorDialog();

            ColorDlg.AllowFullOpen = true;

            // SET INITIAL COLOR TO THE CURRENT OSD BACKGROUND COLOR
            //
            ColorDlg.Color = labelOSDBackgroundColor.BackColor;

            // UPDATE THE TEXTBOX COLOR IF USER CLICK OK
            //
            if (ColorDlg.ShowDialog() == DialogResult.OK)
            {
                labelOSDBackgroundColor.BackColor = ColorDlg.Color;

                m_clrBackground = ColorDlg.Color;

                txtBoxTypeString.BackColor = m_clrBackground;
            }
        }        

        private void comboxFontSize1_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nFontSize = Convert.ToUInt32(comboxFontSize1.Text);            
        }

        private void txtBox_Xoffset1_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Yoffset1_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_width1_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_height1_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Transparent1_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Xoffset2_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Yoffset2_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_width2_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_height2_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Transparent2_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Xoffset3_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Yoffset3_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_width3_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_height3_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        private void txtBox_Transparent3_KeyPress(object sender, KeyPressEventArgs e)
        {
            // USE REGEX FOR NUMBER ONLY TXTBOX
            //
            if (!System.Text.RegularExpressions.Regex.IsMatch(e.KeyChar.ToString(), "\\d+"))
                e.Handled = true;
            else
                e.Handled = false;
        }

        // RGB24 BUFFER DATA ( 64 x 64 PIXELS )
        //
        uint[,] m_n_Yuan_OSD_rgb24_array = new uint[64, 64] 
               
        { { 11329279, 3124479, 1483519, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1549055, 3649535, 12707583, },

         { 1614847, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 3190015, },

         { 1023999, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 1745919, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 38399, 38143, 38399, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38655, 38143, 38143, 39167, 38911, 38143, 38143, 39167, 39423, 39423, 39423, 39423, 39423, 38655, 38143, 38143, 38911, 39423, 39423, 39423, 39423, 39423, 39423, 38911, 37631, 39167, 39423, 39423, 39423, 39423, 39423, 39423, 38911, 38143, 39167, 39423, 39423, 39423, 39423, 39423, 39423, 38655, 38143, 38143, 39167, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39167, 498943, 4437247, 4371455, 3715071, 39167, 39423, 39423, 39423, 39423, 39423, 38911, 2927615, 4371455, 4568575, 1417983, 1942783, 4371455, 4371455, 1417727, 39167, 39423, 39423, 39423, 38911, 2468095, 4371455, 4371455, 1680383, 38911, 39423, 39423, 39423, 39423, 38911, 2336767, 8375551, 1417727, 38911, 39423, 39423, 39423, 39423, 38911, 2008575, 4240127, 39167, 39167, 39423, 39423, 39423, 39423, 39167, 2730495, 4371455, 4305919, 761343, 39167, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39167, 366847, 12707583, 16777215, 16777215, 3846399, 38143, 39423, 39423, 39423, 38655, 1483263, 15464447, 16777215, 16252159, 1548543, 8244223, 16777215, 16777215, 5552895, 38143, 39423, 39423, 39423, 37887, 9753855, 16777215, 16777215, 6603263, 37887, 39423, 39423, 39423, 39423, 37887, 9491455, 16777215, 7325183, 37887, 39423, 39423, 39423, 39423, 37887, 7719167, 16777215, 7193855, 37631, 39423, 39423, 39423, 39423, 38143, 10803967, 16777215, 16777215, 2927615, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 38143, 3452671, 16580351, 16777215, 12707583, 104447, 39167, 39423, 39423, 37887, 9031935, 16777215, 16777215, 8112895, 36095, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39423, 39423, 38911, 892415, 15004927, 16777215, 13363967, 169983, 39167, 39423, 39423, 39423, 37887, 7390975, 16777215, 16252159, 3649279, 38143, 39423, 39423, 39423, 38143, 10410239, 16777215, 16514559, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 37887, 10541567, 16777215, 16777215, 5618687, 37887, 39423, 38655, 2074367, 15923967, 16777215, 14545663, 826623, 37375, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39423, 39423, 37887, 5618687, 16777215, 16777215, 16711423, 3583999, 38399, 39423, 39423, 39423, 37887, 7390975, 16777215, 16777215, 14217471, 1089279, 38655, 39423, 39423, 38143, 10410239, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 38655, 2139903, 15923967, 16777215, 14217215, 629759, 38911, 37887, 10082047, 16777215, 16777215, 6143999, 37887, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39423, 39423, 38399, 11854335, 16777215, 16777215, 16777215, 9556991, 37887, 39423, 39423, 39423, 37887, 7390975, 16777215, 16777215, 16777215, 11066623, 38399, 39167, 39423, 38143, 10410239, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 37887, 8769279, 16777215, 16777215, 7522303, 36863, 2861823, 16317695, 16777215, 13167103, 235775, 39167, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39423, 38655, 2336767, 16252159, 16777215, 16055295, 16777215, 15070463, 892671, 38911, 39423, 39423, 37887, 7390975, 16777215, 16777215, 16777215, 16777215, 7194111, 37631, 39423, 38143, 10410239, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 38911, 1220607, 15070463, 16777215, 15398655, 1220351, 10672895, 16777215, 16777215, 4371455, 38143, 39423, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39423, 37887, 8112895, 16777215, 15792639, 7981567, 16777215, 16777215, 5684223, 37887, 39423, 39423, 37887, 7390975, 16777215, 16777215, 16777215, 16777215, 16252159, 3649279, 38143, 38143, 10410239, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 37887, 7062783, 16777215, 16777215, 12510719, 16055295, 16777215, 11460607, 38399, 39423, 39423, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 39167, 367359, 14020351, 16777215, 12510719, 892415, 15333119, 16777215, 11919871, 38399, 39423, 39423, 37887, 7390975, 16777215, 16711679, 10738431, 16449023, 16777215, 14217471, 1089279, 37375, 10410239, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 38911, 498431, 14020351, 16777215, 16777215, 16777215, 16317695, 2861823, 38399, 39423, 39423, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 38143, 4371455, 16777215, 16777215, 7390975, 36607, 11460351, 16777215, 16252159, 2271231, 38655, 39423, 37887, 7390975, 16777215, 16777215, 4371455, 8178687, 16777215, 16777215, 11001087, 37119, 10278911, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 37887, 5421823, 16711679, 16777215, 16777215, 9556991, 37887, 39423, 39423, 39423, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 39423, 38143, 10607103, 16777215, 16252159, 2271231, 37119, 6471935, 16777215, 16777215, 7981823, 37887, 39423, 37887, 7390975, 16777215, 16777215, 5093631, 103423, 12904703, 16777215, 16777215, 6275071, 9425663, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39167, 104447, 13495295, 16777215, 16055295, 2008575, 38655, 39423, 39423, 39423, 37631, 8441087, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37887, 9425663, 16777215, 16777215, 6406399, 37887, 38911, 1417983, 15661311, 16777215, 11723007, 36863, 36863, 1155327, 15858175, 16777215, 13954815, 301567, 39167, 37887, 7390975, 16777215, 16777215, 5356031, 36863, 2402047, 15595775, 16777215, 15792639, 13692159, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38143, 12248319, 16777215, 15530239, 1023999, 38911, 39423, 39423, 39423, 37631, 8506623, 16777215, 16777215, 5224703, 38143, 39423, 39423, 39423, 37887, 9294335, 16777215, 16777215, 6471935, 37887, 37887, 6734591, 16777215, 16777215, 11788799, 7324415, 7390719, 7325183, 15004927, 16777215, 16777215, 4174591, 38143, 37887, 7390975, 16777215, 16777215, 5356031, 38143, 37887, 5684479, 16777215, 16777215, 16777215, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 12445183, 16777215, 15595775, 1220863, 38911, 39423, 39423, 39423, 37631, 8375295, 16777215, 16777215, 6078207, 37631, 39423, 39423, 39423, 37631, 10278911, 16777215, 16777215, 6078207, 37887, 104447, 12970239, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 16777215, 10344703, 37887, 37887, 7390975, 16777215, 16777215, 5356031, 38143, 39423, 37887, 9622783, 16777215, 16777215, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 12445183, 16777215, 15595775, 1220863, 38911, 39423, 39423, 39423, 37887, 6471935, 16777215, 16777215, 12051199, 38399, 38143, 38655, 37631, 1483263, 14939391, 16777215, 16777215, 3452671, 37375, 3255807, 16580351, 16777215, 15923967, 13166847, 13232639, 13232639, 13232639, 13167103, 16120831, 16777215, 15464447, 1286399, 37375, 7390975, 16777215, 16777215, 5356031, 38143, 39423, 38911, 563967, 13363967, 16777215, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 12445183, 16777215, 15595775, 1220863, 38911, 39423, 39423, 39423, 38655, 2402303, 16514559, 16777215, 16777215, 10476031, 3386367, 2664703, 5093119, 13561087, 16777215, 16777215, 13232639, 301311, 37631, 9294335, 16777215, 16777215, 9031679, 37631, 39167, 39167, 39167, 37887, 10541567, 16777215, 16777215, 6406399, 36351, 7390975, 16777215, 16777215, 5356031, 38143, 39423, 39423, 38143, 2730495, 15792639, 16777215, 16449023, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 12445183, 16777215, 15661311, 1220863, 38911, 39423, 39423, 39423, 39423, 38143, 8769279, 16777215, 16777215, 16777215, 16777215, 16449023, 16777215, 16777215, 16777215, 15530239, 3517951, 37887, 826879, 14939391, 16777215, 16777215, 3715071, 38143, 39167, 39167, 39167, 37887, 5618687, 16777215, 16777215, 12576511, 37119, 7325183, 16777215, 16777215, 5356031, 38143, 39423, 39423, 39423, 37631, 6143743, 16777215, 16580351, 2796287, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 12904703, 16777215, 16120831, 1286399, 38911, 39423, 39423, 39423, 39423, 39167, 38655, 7062527, 15070463, 16777215, 16777215, 16777215, 16777215, 16777215, 12510719, 2927103, 38143, 38143, 6143743, 16777215, 16777215, 14479871, 432895, 39167, 39423, 39423, 39423, 38911, 1680383, 16186367, 16777215, 16777215, 2336767, 7062783, 16777215, 16777215, 5552895, 38143, 39423, 39423, 39423, 39423, 38143, 10278911, 16777215, 2927615, 38655, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39167, 3255807, 4371455, 4043519, 367615, 39167, 39423, 39423, 39423, 39423, 39423, 39167, 37887, 1351935, 5684223, 8375551, 8441087, 7522303, 3846399, 39167, 38399, 39423, 38911, 2599423, 4371455, 4371455, 2861823, 38911, 39423, 39423, 39423, 39423, 39423, 39423, 3583743, 4371455, 4437247, 1483519, 1680383, 4371455, 4371455, 1417727, 39167, 39423, 39423, 39423, 39423, 38911, 761343, 6143743, 1155327, 39167, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 38143, 38399, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38911, 38143, 37631, 37631, 37887, 38399, 39167, 39423, 39423, 39423, 38911, 38143, 38143, 38655, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 38399, 38143, 38143, 39167, 38911, 38143, 38143, 39167, 39423, 39423, 39423, 39423, 39423, 39423, 39167, 38143, 39167, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1220863, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 2008575, },

         { 1023999, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 1877247, },

         { 1745919, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 39423, 3386879, },

         { 11132415, 2205439, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 1220863, 2796287, 12510719, },

         };        

        private void btnApplyOSDBuffer_Click(object sender, EventArgs e)
        {
            m_nOsdNum3 = (uint)comboxOSDLayer3.SelectedIndex;

            m_xoffset3 = Convert.ToInt32(txtBox_Xoffset3.Text);

            m_yoffset3 = Convert.ToInt32(txtBox_Yoffset3.Text);

            m_width3 = Convert.ToInt32(txtBox_width3.Text);

            m_height3 = Convert.ToInt32(txtBox_height3.Text);

            m_nTransparent3 = Convert.ToUInt32(txtBox_Transparent3.Text);

            if (m_hCapDev != 0)
            {
                // EXPORTS.QCAP_SET_OSD_BUFFER(m_hCapDev, m_nOsdNum3, m_xoffset3, m_yoffset3, m_width3,  m_height3, 64 * 24, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_RGB24, m_n_Yuan_OSD_rgb24_array[0, 0], m_nTransparent3);
            }
        }
    }
}
